<?php
/**
 *  Diese Bibliothek liefert die Basisfunktionen, die an verschiedenen Stellen bei einer Installation auf einer Client Webseite erforderlich sind. Neben dieser Bibliothek
 *  wird nur noch die besondere Bibliothek für allgemeine Funktionen gebraucht.
 *  @Name imonit_client_lib
 * @author Stephan Haux
 * @version 00.02.062 10.12.2025
 * @copyright 2025 i-mon-it
 * 
 * 
 */
if (session_status() != PHP_SESSION_ACTIVE) {
    session_start();
    $sessionid = session_id();
}

if (! defined('indev')) {
    define('indev', true);
}
/**
 * Enthält die Version und das letzte Änderungsdatum dieser Bibliothek.
 *
 * @var string Version und Änderungsdatum der Bibliothek.
 */
define('imonit_client_lib_Version', "00.02.062 10.12.2025");

 /**
 * Diese Konstante ist der Rückgabewert bei der Überprüfung des lokalen Tokens
 * @var String Rückgabewert der Lizenzüberprüfung.
 * @see imonit_client::verifytoken ()
 */
if (! defined('tokenok')) {
    define('tokenok', 'token is ok');
} else {}

/**
 * Dies ist der detailierteste Level von Fehlermeldungen, die das Gesamtsystem kennt.
 *
 * @var String
 */
if (! defined('detailiert'))
    define('detailiert', 'detailiert');

if (session_status() == PHP_SESSION_NONE) {
    session_start();
    // debug(detailiert, '<p>Debug:' . __FILE__ . ' (#' . __LINE__ . ') Die Session wurde erfolgreich gestartet. </p>' . PHP_EOL);
} else {
    // debug(detailiert, ' <p >Debug:' . __FILE__ . ' (#' . __LINE__ . ') Eine Session konnte leider nicht gestartet werden. </p>' . PHP_EOL);
}

error_reporting(E_ALL);
if (function_exists('re') == false) {

    // echo ' <p >Debug:'.__FILE__.' (#'.__LINE__.' Version:'.imonit_client_lib_Version.')Es wird die Funktion <b >re </b> Definiert. </p>'. PHP_EOL;

    /**
     * diese Funktion überprüft ob der übergebene Schlüssel in der request Variable gesetzt ist.
     *
     * @param string $key
     *            Name des gesuchten Schlüssels.
     * @return bool Sofern der Schlüssel in der request Variablen vorhandenes wird true zurückgegeben. Andernfalls wird
     *         false zurückgegeben.
     * @see req()
     */
    function re(string $key): bool
    {
        $result = key_exists($key, $_REQUEST);
        // debug(detailiert,'<p>Debug:'.__FILE__.' (#'.__LINE__.' '.imonit_client_lib_Version.') In der request Variable wird nach dem Schlüssel"'. $key.'" gesucht. Gefunden?'.janein ($result).'</p>'.PHP_EOL);
        return $result;
    }
}
if (function_exists('req') == false) {

    // echo ' <p >Debug:'.__FILE__.' (#'.__LINE__.' Version:'.imonit_client_lib_Version.')Es wird die Funktion <b >req </b> Definiert. </p>'. PHP_EOL;
    /**
     * Diese Funktion gibt den Wert der Variable_REQUEST zurück, sofern der übergebene Schlüssel vorhanden ist.
     * Sollte der Schlüssel aktuell nicht vorhanden sein, dann wird
     * eine leere Zeichenkette zurückgegeben.
     *
     * @param string $key
     *            Nach diesen Schlüssel wird in der request Variable gesucht
     *            * @param string $default, dies ist der Defaultwert der zurückgegeben wird, wenn der Schlüssel nicht gefunden wurde.
     *            
     * @return string Wert der request Variable sofern sie existiert.
     * @see re()
     */
    function req(string $key, string $default = ''): string
    {
        $result = $default;
        if (isset($_REQUEST[$key])) {
            $result = $_REQUEST[$key];
        }
        return $result;
    }
}
if (function_exists('uanr') == false) {

    function uanr(string $useragent): int
    {
        //trace(detailiert,__FILE__,__LINE__);
//        debug(detailiert, '<p>Debug:' . __FILE__ . ' (#' . __LINE__ . ' ' . imonit_client_lib_Version . ') als UserAgent wurde übergeben: <br >' . $useragent . '</p>' . PHP_EOL);
        $result = imonit_client::ua($useragent);
       
       // debug (detailiert,' <p >Debug:'.__FILE__.' (#'.__LINE__.' '.imonit_client_lib_Version.') Browsernummer:'. $result.' </p>'.PHP_EOL);
        return $result;
    }
} else {}
if (function_exists('debuglevel')==false) {

    /**
     * Diese Funktion übersetzt die Stringkonstanten für die Fehlerlevel in ganzzahligen Werte, welche dann verglichen werden können, um
     * zu entscheiden ob eine Fehlermeldung angezeigt wird oder nicht.
     *
     * @param string $debuglevel
     *            Enthält als Stringden gewünschten Level in dem die Meldung angezeigt werden soll.
     *            Der unzureichende Fehlerlevel
     * @return int der ganzzahligen Wert des übergebenen Fehler levels
     */
    function debuglevel(string $debuglevel = defaultdebug): int
    {
        $result = 0;
        switch ($debuglevel) {
            case 'detailiert':
                $result = 0;
                break;
            case 'Warnung':
                $result = 1;
                break;
            case 'Fehler':
                $result = 2;
                break;
            case 'Fatal':
                $result = 3;
                break;
            Default:
                $result = 0;
                break;
        }
        return $result;
    }

    /**
     * Liefert basierend auf dem übergebenen Fehlerlevel einen logischen Wert, welche anzeigt ob eine Fehlermeldung angezeigt werden soll, oder nicht.
     *
     * @param string $level
     *            Text des Fehler levels der mit dem eingestellten Standard Fehlerlevel verglichen werden muss.
     * @return bool
     * @see debuglevel()
     */
    function debug_show(string $level = defaultdebug): bool
    {
        $result = false;
        $level = debuglevel($level);
        $result = ($level >= debuglevel($level));
        return $result;
    }
} else {
    // dies ist der Bereich der ausgeführt wird wenn die Funktionen debuglevel und debug_show bereits definiert sind.
}

If (! function_exists('debug')) {

    /**
     * Diese Funktion ermöglicht eine simple und standardisierte Darstellung von Meldungen zum Zwecke der Fehlersuche und während der Entwicklungszeit.
     *
     * @param string $level
     *            Name des levels, welchen diese Meldung nach Meinung des Programmierers hat.
     * @param string $msg
     *            Anzuzeigende Meldung.
     * @return bool Die Funktion gibt zurück, ob die Meldung im aktuellen Kontext angezeigt wurde oder nicht. Eine Nutzung und Verarbeitung ist optional. In der bisherigen Programmierpraxis wird dies nicht verwendet.
     */
    function debug(string $level = defaultdebug, string $msg = ''): bool
    {
        $result = debug_show($level);
        if ($result)
            echo $msg;
        return $result;
    }
} else {
    // Dies ist der Bereich der ausgeführt wird, wenn die Funktion (debug) bereits vorher schon einmal definiert wurde.
}

if (indev) {}
if (! function_exists('getgender')) {

    /**
     * Übersetzt ein einzelenes in der Datenbank verwendetes Zeichen in Gender in eine Anrede
     *
     * @param string $Gender
     *            "u","w",'d'
     * @return string "Herr, "Frau', "Guten Tag",""
     *        
     */
    function getGender(string $Gender)
    {
        $Gender = substr(trim($Gender), 0, 1);
        $result = "nicht gefunden Gender:" . $Gender . "end Gender";

        switch ($Gender) :
            case "u":
                $result = "unbekannt";
                break;
            case "m":
                $result = "Herr";
                break;
            case "d":
                $result = "Guten Tag";
                break;
            case "w":
                $result = "Frau";
                break;
            default:
                $result = "";
                break;
        endswitch
        ;
        return $result;
    }
} else {
    // dieser Bereich ausgeführt wenn die Funktiongetgender bereits vorher definiert wurde.
}

if (! function_exists('imonit_client_lib_version')) {

    function imonit_client_lib_version(): string
    {
        return imonit_client_lib_Version;
    }
}
if (! function_exists('janeintobool')) {

    /**
     *
     * @param string $input
     * @return bool
     */
    function janeintobool(string $input): bool
    {
        $input = trim($input);
        $input = strtolower($input);
        $result = ($input == 'Ja');
        return $result;
    }
} else {
    // Dies ist der Bereich wenn die Funktion jaeintobool bereits existiert.
}
if (!function_exists ('rec_check')) {
/**
 * MitHilfe dieser Funktion kann überprüft werdenkann, ob die Gefahr einer endlosen Rekursion besteht. Die Funktion gibt zurück, ob  die Anzahl der Rekursionsschleifen
 *  einen bestimmten Wert erreicht hat oder übersteigt, in diesem Fall wird der Wert true  zurückgegeben, sodass das Überprüfen der Programmodul gegebenenfalls
 *   abbrechen kann und somit die Rekursionsschleife unterbrochen wird. Standardmäßig wird bei einer Rekursionstiefe von zehn abgebrochen.
 * @param int $depth Optionaler Parameter, der die geduldete Rekursionstiefe darstellt. Der Standardwert liegt bei einer Tiefe von zehn
 * @return bool gibt zurück ob die maximale Regionstiefe erreicht worden ist (Rückgabewert:true) oder eben nicht (Rückgabewert:false).
 */
function rec_check(int $depth = 10):bool {
    if ($depth<0){
        $depth = 10;
    }
    $trace = debug_backtrace();
    $result = false;
    $result = (count($trace)>= $depth);
    return $result;
}
} else  {}
if (! function_exists('janein')) {

    /**
     * Gibt die Zeichenketten Ja oder nein zurück
     *
     * @param bool $wert
     *            Logischer wert, der in 'ja'/'nein' umgewandelt wird
     * @return string Ja oder Nein je nach Parameter
     */
    function janein(bool $value)
    {
        if ($value == true) {
            return "Ja";
        } else {
            return "Nein";
        }
    } // getjanein
} else {
    // Das ist der Bereich der ausgeführt wird, wenn die Funktion (janein) bereits definiert wurde.
}

if (function_exists('standardize')) {} else {

    function standardize(string $methodorfile): string
    {
        $result = trim($methodorfile);
        if(str_contains($methodorfile, '/')) {
            return $result;
        }else {
        $result = addslashes($result);
        return $result;
        }
    }
}

/**
 * This function identifies the user agent used by the clients website.
 *
 * @return string Name of the user agent. In case it cannot be determined the function will return'unknown'.
 */
function getuseragent(): string
{
    $result = 'unknown';
    if (isset($_SERVER['HTTP_USER_AGENT'])) {
        $result = $_SERVER['HTTP_USER_AGENT'];
    } else {}
    $result = strtr($result, ' ', '_');
    return $result;
}
?>